'-------------------------------------------
'JUNE 1, 1996  by Michael J. Gothelf
'
'Sample of Masked input code .... Can be linked into a library
'There are NO ROYALTIES.
'
'DISCLAIMER: I am not responsible for SYSTEM failures, use at your own risk.
'-------------------------------------------
DECLARE SUB TestSETUP ()
DEFINT A-Z
'$INCLUDE: 'MASKINPT.CAL'
'$INCLUDE: 'FLDUTIL.CAL'

'$INCLUDE: 'FLDINFO.TYP'
'$INCLUDE: 'FDFORMAT.CON'
'$INCLUDE: 'COLORS.CON'

CONST TRUE% = -1, FALSE% = 0    '<- Good to have in all code

'-----[Test just the display & load routine...QBX SETUPFLD]
CALL TestSETUP
'-----------------------------

FieldSETUP:
'- Number of fields
DATA 3
'                                                               COLOUR
'-   FIELD     FType   Format   Length  Decimal POSx  POSy  (Char, Background) Default
DATA LASTNAME,   0,      0,       30,      0,     24,    7,    15, 1,            ""
DATA FRSTNAME,   0,      0,       25,      0,     24,    9,    15, 1,            ""
DATA FONENUMB,   8,      0,       10,      0,     18,   11,    15, 1,            ""

FUNCTION MaskINFO$ (FieldType%, Length%, Decimal%)

  SELECT CASE FieldType
    CASE PhonNUMB: Mask$ = "(###)###-####"
    CASE StrTYPE:  Mask$ = STRING$(Length, "$")
    CASE NumTYPE:  Mask$ = STRING$(Length, "#")
      IF (Decimal) THEN MID$(Mask$, Decimal, 1) = "."
  END SELECT

  MaskINFO$ = Mask$
END FUNCTION

SUB PrintFLDS (FirstFLD%, LastFLD%, FieldINFO() AS FieldINFOtype, FieldData$())

  FOR FieldNo = FirstFLD TO LastFLD
    StrINPUT$ = FieldData$(FieldNo)
    Mask$ = MaskINFO$(FieldINFO(FieldNo).FType, FieldINFO(FieldNo).Length, FieldINFO(FieldNo).Decimal)
    DispSTR$ = Str2Mask$(StrINPUT$, Mask$)

    COL = FieldINFO(FieldNo).POSx: ROW = FieldINFO(FieldNo).POSy
    CharCOLOR = FieldINFO(FieldNo).ColorCHAR
    BackCOLOR = FieldINFO(FieldNo).ColorBACK
    CALL PrintSTR(COL, ROW, DispSTR$, CharCOLOR, BackCOLOR)
  NEXT FieldNo

END SUB

SUB SetupFields (FieldINFO() AS FieldINFOtype, FieldData$(), FieldDefault$())
'-   FIELD     FType   Format   Length  Decimal POSx  POSy  (Char, Background) Default
'DATA LASTNAME,   0,      4,       30,      0,      1,    1,    15, 1,            ""
'DATA FRSTNAME,   0,      0,       25,      0,      3,    1,    15, 1,            ""
'DATA FONENUMB,   0,      8,       13,      0,      4,    1,    15, 1,            ""

'-----------[Load field information from here]
'--[I will read it from a Data line, you might want to try a file]

  RESTORE FieldSETUP
  READ NoFields
  
  REDIM FieldINFO(NoFields)   AS FieldINFOtype  '<- Information about the field
  REDIM FieldData$(NoFields)                    '<- Storage for field info.
  REDIM FieldDefault$(NoFields)                 '<- Storage for field default
                                                '   value.

'- Load in the field information -  'NOTE: NoFields = UBOUND(FieldINFO)
  FOR FieldNo = 1 TO NoFields
    READ FieldINFO(FieldNo).Name
    READ FieldINFO(FieldNo).FType
    READ FieldINFO(FieldNo).Format
    READ FieldINFO(FieldNo).Length
    READ FieldINFO(FieldNo).Decimal
    READ FieldINFO(FieldNo).POSx
    READ FieldINFO(FieldNo).POSy
    READ FieldINFO(FieldNo).ColorCHAR
    READ FieldINFO(FieldNo).ColorBACK
    READ FieldDefault$(FieldNo)
    FieldData$(FieldNo) = SPACE$(FieldINFO(FieldNo).Length)
    IF LEN(FieldDefault$(FieldNo)) THEN   '<- Assign a default
      LSET FieldData$(FieldNo) = FieldDefault$(FieldNo)
    END IF
  NEXT FieldNo
  
END SUB

SUB TestSETUP
  CLS

  REDIM FieldINFO(0) AS FieldINFOtype, FieldData$(0), FieldDefault$(0)

  CALL SetupFields(FieldINFO(), FieldData$(), FieldDefault$())

  END
END SUB

